﻿' 版权所有 (C) Microsoft Corporation。保留所有权利。
' 此类被标记为可序列化。
<Serializable()> Public Class SerializableClass

    ' 无论属于哪个范围，此类中的所有字段都将被序列化， 
    ' 除非被专门标记为 NonSerialized，如 z。

    Public PublicVariable As Integer
    Private privateVariable As Integer
    <NonSerialized()> Public NonSerializedVariable As Integer


    ''' <summary>
    ''' 要加载到字段的值中的简单构造函数。
    ''' </summary>
    ''' <remarks></remarks>
    Public Sub New(ByVal publicVar As Integer, ByVal privateVar As Integer, ByVal nonSerializedVar As Integer)
        Me.PublicVariable = publicVar
        Me.privateVariable = privateVar
        Me.NonSerializedVariable = nonSerializedVar
    End Sub


    ''' <summary>
    ''' 用于查看私有字段 y 的值的属性。
    ''' </summary>
    Public ReadOnly Property PublicProperty() As Integer
        Get
            Return privateVariable
        End Get
    End Property
End Class
